-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema runner2kanban
--

-- CREATE DATABASE IF NOT EXISTS kanban;
-- USE kanban;

--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `idx2_catalog` (`super_catalog_idsuper_catalog`,`catalog_code`),
  KEY `idx3_catalog` (`group_num`,`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'English','Inglés',NULL),
 (2,1,'',1,'Spanish','Español',NULL),
 (3,2,'English',0,'Public','Pública',NULL),
 (4,2,'English',1,'Private','Privada',NULL),
 (5,2,'Spanish',0,'Pública','',NULL),
 (6,2,'Spanish',1,'Privada','',NULL),
 (7,3,'English',0,'Not','no',NULL),
 (8,3,'English',1,'Yes','sí',NULL),
 (9,3,'Spanish',0,'No','',NULL),
 (10,3,'Spanish',1,'Sí','',NULL),
 (11,4,'English',0,'Good','Green',NULL),
 (12,4,'English',1,'Warning','Orange',NULL),
 (13,4,'English',2,'Problems','Red',NULL),
 (14,4,'English',3,'Locked','Red + Locked',NULL),
 (15,4,'Spanish',0,'Bien','Verde',NULL),
 (16,4,'Spanish',1,'Advertencia','Naranja',NULL),
 (17,4,'Spanish',2,'Problemas','Rojo',NULL),
 (18,4,'Spanish',3,'Bloqueado','Rojo + Bloqueado',NULL),
 (19,5,'English',0,'Planning','Planificación',NULL),
 (20,5,'English',1,'Production','En Producción',NULL),
 (21,5,'English',2,'Finished','Terminado',NULL),
 (22,5,'Spanish',0,'Planificación','',NULL),
 (23,5,'Spanish',1,'Producción','',NULL),
 (24,5,'Spanish',2,'Terminado','',NULL),
 (25,7,'English',0,'Days','',NULL),
 (26,7,'English',1,'Hours','',NULL),
 (27,7,'Spanish',0,'Días','',NULL),
 (28,7,'Spanish',1,'Horas','',NULL),
 (29,8,'',0,'0 %','',NULL),
 (30,8,'',10,'10 %','',NULL),
 (31,8,'',20,'20 %','',NULL),
 (32,8,'',30,'30 %','',NULL),
 (33,8,'',40,'40 %','',NULL),
 (34,8,'',50,'50 %','',NULL),
 (35,8,'',60,'60 %','',NULL),
 (36,8,'',70,'70 %','',NULL),
 (37,8,'',80,'80 %','',NULL),
 (38,8,'',90,'90 %','',NULL),
 (39,8,'',100,'100 %','',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `company_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone1` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `address1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `address2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `owner` int(10) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `private` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`company_id`),
  KEY `company_name` (`name`),
  KEY `company_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `companies`
--

/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`company_id`,`name`,`phone1`,`fax`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`primary_url`,`owner`,`description`,`email`,`private`) VALUES 
 (0,'Administración','','','','','','','','','',6,'','info@fhumanes.com',1),
 (3,'Compañía 1','','','','','','','','','',6,'','info@fhumanes.com',0);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`,`group`,`type`) VALUES 
 (2,'KANBAN_PATH','jkanban','',''),
 (3,'KANBAN_ICON','jkanban/icon','',''),
 (5,'KANBAN_AJAX','kanban_ajax.php','','');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `dept_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`dept_id`),
  KEY `dept_name` (`name`),
  KEY `fk_departments_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_departments_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Department heirarchy under a company';

--
-- Dumping data for table `departments`
--

/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`dept_id`,`companies_company_id`,`name`,`phone`,`fax`,`desc`,`email`) VALUES 
 (1,3,'Departament 1','','','','info@fhumanes.com');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;


--
-- Definition of table `files`
--

DROP TABLE IF EXISTS `files`;
CREATE TABLE `files` (
  `file_id` int(10) NOT NULL AUTO_INCREMENT,
  `tasks_task_id` int(10) DEFAULT NULL,
  `description` varchar(100) NOT NULL DEFAULT '',
  `files_content` varchar(500) NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `word` (`description`),
  KEY `fk_files_tasks1_idx` (`tasks_task_id`),
  CONSTRAINT `fk_files_tasks1` FOREIGN KEY (`tasks_task_id`) REFERENCES `tasks` (`task_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `files`
--

/*!40000 ALTER TABLE `files` DISABLE KEYS */;
/*!40000 ALTER TABLE `files` ENABLE KEYS */;


--
-- Definition of table `kanban_noti`
--

DROP TABLE IF EXISTS `kanban_noti`;
CREATE TABLE `kanban_noti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` mediumtext,
  `user` varchar(255) DEFAULT NULL,
  `provider` varchar(5) DEFAULT NULL,
  `title` varchar(300) DEFAULT NULL,
  `url` mediumtext,
  `icon` varchar(300) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `expire` datetime DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `group` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanban_noti`
--

/*!40000 ALTER TABLE `kanban_noti` DISABLE KEYS */;
INSERT INTO `kanban_noti` (`id`,`message`,`user`,`provider`,`title`,`url`,`icon`,`created`,`expire`,`type`,`group`) VALUES 
 (1,'Task 15 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 11:28:18','2022-03-23 11:28:18',0,NULL),
 (2,'Task 16 moved to Archived','admin',NULL,'Task moved','','fa-envelope','2022-03-22 11:31:44','2022-03-23 11:31:44',0,NULL),
 (3,'Task 16 moved to Done','admin',NULL,'Task moved','','fa-envelope','2022-03-22 11:32:00','2022-03-23 11:32:00',0,NULL),
 (4,'{\"lastRead\":25}','admin','',NULL,NULL,NULL,NULL,NULL,1,NULL),
 (5,'Task 10 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 13:56:56','2022-03-23 13:56:56',0,NULL),
 (6,'Task 10 moved to Idea','admin',NULL,'Task moved','','fa-envelope','2022-03-22 13:57:11','2022-03-23 13:57:11',0,NULL),
 (7,'Task 16 moved to Archived','admin',NULL,'Task moved','','fa-envelope','2022-03-22 13:59:31','2022-03-23 13:59:31',0,NULL),
 (8,'Task 15 moved to Done','admin',NULL,'Task moved','','fa-envelope','2022-03-22 14:08:00','2022-03-23 14:08:00',0,NULL),
 (9,'Task 15 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 14:08:08','2022-03-23 14:08:08',0,NULL),
 (10,'Task 10 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 14:08:21','2022-03-23 14:08:21',0,NULL),
 (11,'Task 10 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 14:17:14','2022-03-23 14:17:14',0,NULL),
 (12,'Task 10 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 14:17:20','2022-03-23 14:17:20',0,NULL),
 (13,'Task 10 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:41:03','2022-03-23 18:41:03',0,NULL),
 (14,'Task 10 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:46:58','2022-03-23 18:46:58',0,NULL),
 (15,'Task 10 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:47:01','2022-03-23 18:47:01',0,NULL),
 (16,'Task 10 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:52:45','2022-03-23 18:52:45',0,NULL),
 (17,'Task 10 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:52:49','2022-03-23 18:52:49',0,NULL),
 (18,'Task 10 moved to Done','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:52:52','2022-03-23 18:52:52',0,NULL),
 (19,'Task 11 moved to Idea','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:54:10','2022-03-23 18:54:10',0,NULL),
 (20,'Task 11 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 18:55:16','2022-03-23 18:55:16',0,NULL),
 (21,'Task 11 moved to Doing','admin',NULL,'Task moved','','fa-envelope','2022-03-22 19:34:22','2022-03-23 19:34:22',0,NULL),
 (22,'Task 11 moved to to-Do','admin',NULL,'Task moved','','fa-envelope','2022-03-22 19:34:28','2022-03-23 19:34:28',0,NULL),
 (23,'Task 10 moved to Archived','admin',NULL,'Task moved','','fa-envelope','2022-03-22 19:36:50','2022-03-23 19:36:50',0,NULL),
 (24,'Task 16 moved to Done','admin',NULL,'Task moved','','fa-envelope','2022-03-22 19:37:26','2022-03-23 19:37:26',0,NULL),
 (25,'Task 10 moved to Done','admin',NULL,'Task moved','','fa-envelope','2022-03-22 19:37:28','2022-03-23 19:37:28',0,NULL);
/*!40000 ALTER TABLE `kanban_noti` ENABLE KEYS */;


--
-- Definition of table `kanban_settings`
--

DROP TABLE IF EXISTS `kanban_settings`;
CREATE TABLE `kanban_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanban_settings`
--

/*!40000 ALTER TABLE `kanban_settings` DISABLE KEYS */;
INSERT INTO `kanban_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":1115.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":15.399999999999999,\"grid_headcell_details\":33.4,\"grid_headcell_details1\":52.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":83.4,\"grid_headcell_field2\":79.4,\"grid_headcell_field3\":63.4,\"grid_headcell_field4\":37.4,\"grid_headcell_field5\":89.4,\"grid_headcell_field6\":142.4,\"grid_headcell_field7\":86.4,\"grid_headcell_field8\":93.4,\"grid_headcell_field9\":90.4,\"grid_headcell_field10\":40.4}}','projects'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":983.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":76.4,\"grid_headcell_field2\":42.4,\"grid_headcell_field6\":20.4,\"grid_headcell_field11\":244.4,\"grid_headcell_field12\":407.4}}','companies'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":923.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":143.4,\"grid_headcell_field2\":164.4,\"grid_headcell_field3\":36.4,\"grid_headcell_field4\":19.4,\"grid_headcell_field5\":108.4,\"grid_headcell_field6\":248.4}}','departments'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":723,\"thWidths\":{\"grid_headcell_icons\":20,\"grid_headcell_field\":10,\"grid_headcell_field2\":194,\"grid_headcell_field3\":458}}','files'),
 (5,2,NULL,'admin',NULL,'{\"gridWidth\":558.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":16.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":44.4,\"grid_headcell_field2\":30.4,\"grid_headcell_field3\":35.4,\"grid_headcell_field4\":44.4,\"grid_headcell_field5\":259.4}}','lanes'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":779.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":16.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":194.4,\"grid_headcell_field2\":390.4,\"grid_headcell_field3\":35.4,\"grid_headcell_field4\":26.4}}','config');
/*!40000 ALTER TABLE `kanban_settings` ENABLE KEYS */;


--
-- Definition of table `kanban_uggroups`
--

DROP TABLE IF EXISTS `kanban_uggroups`;
CREATE TABLE `kanban_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  `Comment` mediumtext,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanban_uggroups`
--

/*!40000 ALTER TABLE `kanban_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `kanban_uggroups` ENABLE KEYS */;


--
-- Definition of table `kanban_ugmembers`
--

DROP TABLE IF EXISTS `kanban_ugmembers`;
CREATE TABLE `kanban_ugmembers` (
  `UserName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`UserName`,`GroupID`,`Provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanban_ugmembers`
--

/*!40000 ALTER TABLE `kanban_ugmembers` DISABLE KEYS */;
INSERT INTO `kanban_ugmembers` (`UserName`,`GroupID`,`Provider`) VALUES 
 ('admin',-1,''),
 ('user1',-1,''),
 ('user2',-1,'');
/*!40000 ALTER TABLE `kanban_ugmembers` ENABLE KEYS */;


--
-- Definition of table `kanban_ugrights`
--

DROP TABLE IF EXISTS `kanban_ugrights`;
CREATE TABLE `kanban_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanban_ugrights`
--

/*!40000 ALTER TABLE `kanban_ugrights` DISABLE KEYS */;
INSERT INTO `kanban_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('catalog',-1,'ADESPIM',NULL),
 ('companies',-1,'ADESPIM',NULL),
 ('config',-1,'ADESPIM',NULL),
 ('departments',-1,'ADESPIM',NULL),
 ('files',-1,'ADESPIM',NULL),
 ('kanban',-1,'ADESPIM',NULL),
 ('lanes',-1,'ADESPIM',NULL),
 ('lv_catalog',-1,'ADESPIM',NULL),
 ('projects',-1,'ADESPIM',NULL),
 ('super_catalog',-1,'ADESPIM',NULL),
 ('tasks',-1,'ADESPIM',NULL),
 ('users',-1,'ADESPIM',NULL);
/*!40000 ALTER TABLE `kanban_ugrights` ENABLE KEYS */;


--
-- Definition of table `lanes`
--

DROP TABLE IF EXISTS `lanes`;
CREATE TABLE `lanes` (
  `idlanes` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `color` varchar(7) COLLATE utf8_unicode_ci NOT NULL,
  `orden` int(11) NOT NULL DEFAULT '0',
  `is_end` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idlanes`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `lanes`
--

/*!40000 ALTER TABLE `lanes` DISABLE KEYS */;
INSERT INTO `lanes` (`idlanes`,`name`,`color`,`orden`,`is_end`,`description`) VALUES 
 (1,'Idea','#E3BA14',1,'0',''),
 (2,'to-Do','#17A1CF',2,'0',''),
 (3,'Doing','#14C725',3,'0',''),
 (4,'Done','#E968ED',4,'0',''),
 (5,'Archived','#575454',5,'1','Los archivados no salen en el panel\r\n\r\nThe archives do not come out on the panel');
/*!40000 ALTER TABLE `lanes` ENABLE KEYS */;


--
-- Definition of table `projects`
--

DROP TABLE IF EXISTS `projects`;
CREATE TABLE `projects` (
  `project_id` int(10) NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `short_name` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner` int(10) NOT NULL DEFAULT '0',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` int(10) DEFAULT '0',
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci DEFAULT '#FFFFFF',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `worked_hours` float NOT NULL DEFAULT '0',
  `creator` int(10) DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '1',
  `project_updator` int(10) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `updated` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `status_comment` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`project_id`),
  KEY `idx_project_owner` (`owner`),
  KEY `project_name` (`name`),
  KEY `project_short_name` (`short_name`),
  KEY `project_start_date` (`start_date`),
  KEY `project_end_date` (`end_date`),
  KEY `project_status` (`status`),
  KEY `project_creator` (`creator`),
  KEY `fk_projects_companies_idx` (`companies_company_id`),
  KEY `fk_projects_departments1_idx` (`departments_dept_id`),
  CONSTRAINT `fk_projects_companies` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_projects_departments1` FOREIGN KEY (`departments_dept_id`) REFERENCES `departments` (`dept_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `projects`
--

/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`project_id`,`companies_company_id`,`departments_dept_id`,`short_name`,`name`,`owner`,`start_date`,`end_date`,`status`,`color_identifier`,`description`,`worked_hours`,`creator`,`active`,`project_updator`,`created`,`updated`,`status_comment`) VALUES 
 (2,3,NULL,'P22/001','Proyecto 1',6,'2022-03-22',NULL,1,'#222DA8','Descripción del proyecto',0,6,1,6,'2019-11-13 16:30:05','2022-03-22 18:54:41',''),
 (3,3,1,'P22/002','Proyecto 2',6,'2022-03-22',NULL,1,'#ABBCD6','',0,6,1,6,'2019-11-18 14:15:41','2022-03-22 18:54:56','');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'LANGUAGE','Idiomas de los literales'),
 (2,'COMPANY','Type of Companies'),
 (3,'DECISION','Afirmativo y negativo'),
 (4,'SITUATION_TASK','Situación de las Tareas'),
 (5,'STATUS_PROJ','Status of Project'),
 (7,'DURATION_TYPE','Tipo de Duración'),
 (8,'PERCENT','% PREFIJADOS');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
CREATE TABLE `tasks` (
  `task_id` int(10) NOT NULL AUTO_INCREMENT,
  `projects_project_id` int(10) NOT NULL,
  `name` varchar(60) DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `duration` float unsigned DEFAULT '0',
  `duration_type` int(10) NOT NULL DEFAULT '1',
  `hours_worked` float unsigned NOT NULL DEFAULT '0',
  `end_date` datetime DEFAULT NULL,
  `status` int(10) DEFAULT '0',
  `situation` int(10) DEFAULT '0',
  `percent_complete` int(11) DEFAULT '0',
  `description` longtext,
  `related_url` varchar(255) DEFAULT NULL,
  `creator` int(10) NOT NULL DEFAULT '0',
  `owner` int(10) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `dependent` int(10) DEFAULT NULL,
  `updator` int(10) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  KEY `idx_task1` (`start_date`),
  KEY `idx_task2` (`end_date`),
  KEY `task_name` (`name`),
  KEY `task_start_date` (`start_date`),
  KEY `task_end_date` (`end_date`),
  KEY `task_status` (`status`),
  KEY `task_creator` (`creator`),
  KEY `task_updator` (`updator`),
  KEY `fk_tasks_projects1_idx` (`projects_project_id`),
  KEY `fk_tasks_tasks2_idx` (`dependent`),
  CONSTRAINT `fk_tasks_projects1` FOREIGN KEY (`projects_project_id`) REFERENCES `projects` (`project_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tasks_tasks2` FOREIGN KEY (`dependent`) REFERENCES `tasks` (`task_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `tasks`
--

/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`task_id`,`projects_project_id`,`name`,`start_date`,`duration`,`duration_type`,`hours_worked`,`end_date`,`status`,`situation`,`percent_complete`,`description`,`related_url`,`creator`,`owner`,`access`,`dependent`,`updator`,`created`,`updated`) VALUES 
 (10,2,'Tarea 1','2022-03-31 00:00:00',12,0,0,NULL,4,0,0,'Descripción detallada de la tarea','http://localhost/',6,6,0,NULL,6,'2019-11-13 19:43:01','2022-03-22 19:37:11'),
 (11,2,'Tarea 2 Lorem Ipsum','2022-03-16 00:00:00',5,0,0,NULL,2,1,0,'Esta es una tarea para ....','',6,6,0,NULL,6,'2019-11-18 13:18:08','2022-03-22 13:58:00'),
 (12,3,'tarea 3','2022-03-24 00:00:00',15,0,0,NULL,1,0,0,'descripción completa de la tarea 3 .......','',6,6,0,NULL,6,'2019-11-18 14:16:19','2022-03-22 13:58:40'),
 (13,3,'Tarea 4','2019-11-06 00:00:00',7,0,0,NULL,2,1,0,'descripción de la Tarea 4 ...','',6,7,0,NULL,6,'2019-11-19 13:12:07','2022-03-22 13:58:50'),
 (15,3,'Tarea 15','2020-01-03 00:00:00',2,0,0,NULL,3,0,0,'','',6,6,0,NULL,6,'2019-12-15 21:10:01','2022-03-22 13:59:03'),
 (16,2,'Pruebas','2022-03-17 00:00:00',0,0,0,NULL,4,0,0,'asaas','',6,6,0,NULL,6,'2021-02-06 18:40:37','2022-03-22 19:37:18');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user@domain.com',
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_username` (`username`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  KEY `user_login` (`login`),
  CONSTRAINT `fk_users_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`,`login`,`companies_company_id`,`departments_dept_id`,`username`,`password`,`signature`,`email`,`reset_token`,`reset_date`) VALUES 
 (6,'admin',0,NULL,'Fernando Humanes','21232f297a57a5a743894a0e4a801fc3','','info@fhumanes.com',NULL,NULL),
 (7,'user1',3,1,'Usuario 1','24c9e15e52afc47c225b757e7bee1f9d',NULL,'user1@fhumanes.com',NULL,NULL),
 (8,'user2',3,NULL,'Usuario 2','7e58d63b60197ceb55a1c487989a3720',NULL,'user2@fhumanes.com',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
